﻿/**********************************
* @file i2c.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.19
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/
#include "CSU38F20.h"
#include "i2c.h"

//==============================================================	
//  发送和接收UART程序                                                    
//==============================================================

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void i2c_init(void)
* @brief  i2c init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void i2c_init(void);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  void i2c_init(void)
* @brief  i2c init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void i2c_init(void)
{
	I2CADR = 0x26<<1;	//i2c从机默认地址为0x26，用户可自行设置
	GC_EN = 0;			//不使能从机广播地址响应
	AWK_EN = 0;			//关闭异步唤醒，只有关闭了异步唤醒，i2c使能才能有效，若需使用异步唤醒功能，则需将i2c从机使能关闭
	CST_EN = 0;			//关闭从机时钟低电平延长，若主机支持此功能，可选择开启，以便于数据准备
	ACK_EN = 1;			//使能i2c从机响应
	I2C_SEL = 0;		//PT5.2为SDA，PT5.3为SCL
	I2C_DIV_1 = 0;		//I2C从机时钟为4MHz
	I2C_DIV_0 = 0;
	I2C_INTE = 0xE0;
	GIE = 1;
	I2C_EN = 1;			//使能i2c
}

